# SuperbHR Delivery Plan

This document tracks the end-to-end delivery plan for the SuperbHR platform. It includes scope, phases, milestones, current status, and next actions. It is kept in-repo so engineering, product, and ops can stay aligned.

## North Star & Principles
- Maker–checker workflows for Leave, Training, Appraisals, Payroll with HR Head as final approver.
- Clear role model: Admin, HR Head/Lead, HR Officer, Manager, Employee.
- Organization modeling: Company, Sub-companies, Departments, Branches/Units, Positions, Reporting lines.
- Reliable, observable system (correlation IDs, logs, audits) with strong security.
- Clean UI/UX (Kaiadmin Lite), simple routing, responsive layout.

## Tech Stack
- Backend: PHP (vanilla), MariaDB/MySQL.
- Frontend: HTML, Bootstrap 5, vanilla JS, Chart.js.
- Server: XAMPP (Apache + MariaDB) for local dev.
- Observability: Server file logs (`storage/logs/app.log`), DB logs (`activity_logs`, `system_logs`), client logger (`assets/js/logger.js`), correlation header `X-Request-ID`.

## How to Run (local)
1. Start XAMPP (Apache + MySQL).
2. Create DB `superbhr` and import the provided schema/seed SQL.
3. Configure `config/database.php` with your MySQL credentials.
4. Visit `http://localhost/newsuperbhr/`. Do not open `index.html` directly.
5. Login using seeded credentials (e.g., `admin` / `password`).

## Observability (Tracing issues end-to-end)
- Every API response includes `X-Request-ID` and a `request_id` in JSON body.
- Server logs at `storage/logs/app.log`. DB logs in `activity_logs`.
- Browser auto logs API calls, errors, and navigation via `assets/js/logger.js`.
- To debug any failure: capture the Request ID from the toast or Network tab, then grep it in `app.log` and `activity_logs`.

---

## Phased Plan & Status

- [x] Phase 0: Observability & Stabilization
  - Request IDs, server file logs, `activity_logs`, client logger, centralized error handling, `display_errors=0`.
- [x] Phase 1: Auth & RBAC – Backend endpoints (`api/auth.php`)
- [ ] Phase 1: Auth & RBAC – User & Role Management UI (create users, assign roles, reset status)
- [ ] Password reset flow (`password_resets`), change password, `must_change_password`
- [ ] Optional: Two-factor auth toggle and backup codes

- [x] Phase 2: Organization – API (`api/organization.php`)
- [ ] Phase 2: Organization – UI pages for branches, positions, sub-companies; reporting heads
- [ ] Org chart visualization and reporting line editor

- [x] Phase 3: Employees – Core CRUD API/UI (`api/employees.php`, `assets/js/employees.js`)
- [ ] Employee profile extensions (personal, contact, emergency, compensation) UI
- [ ] Employee documents upload & secure storage (`employee_documents`)
- [ ] Skills & certificates (`skills`, `certificates`, `employee_skills`, `employee_certificates`)
- [ ] Benefits enrollment UI (`benefits`, `employee_benefits`)

- [ ] Phase 4: Leave – API enhancements (multi-level approvals, balances)
- [ ] Leave UI: request, manager/HR approval, balances, history (`assets/js/leave.js`)
- [ ] Leave calendar (team/company) and reports/export

- [ ] Phase 5: Training – Scope approvals for manager’s direct reports; add HR final approval stage
- [ ] Training UI: catalog, enroll/approve, participants, completion/certificates (`assets/js/training.js`)
- [ ] Training certificates issuance & downloads

- [ ] Phase 6: Appraisals – Templates & scoring model
- [ ] Appraisals UI: create, submit, review, approve; dashboards & export (`assets/js/appraisal.js`)
- [ ] Appraisal analytics/reports

- [ ] Phase 7: Payroll – Payroll run UI (select employees, period, approve/pay)
- [ ] Allowances & deductions UI (types + employee assignments)
- [ ] Payslip viewer & PDF export; tax rules configuration

- [ ] Phase 8: Attendance – API & UI for daily logs, statuses, OT; import CSV
- [ ] Attendance rules (late, half-day) and summaries

- [ ] Phase 9: Recruitment – API/UI for postings, candidates, applications
- [ ] Public job board & application form

- [ ] Phase 10: Benefits – Admin UI and payroll integration

- [x] Phase 11: Announcements – API/UI (`api/announcements.php`, `assets/js/announcements.js`)
- [ ] Add dashboard panel & audience targeting controls
- [x] Phase 11: Notifications – API/UI (`api/notifications.php`, `assets/js/notifications.js`)
- [ ] Email delivery (PHPMailer) and preferences

- [x] Phase 12: Analytics – Metrics & insights (`api/analytics.php`, dashboard charts)
- [ ] Filters, exports, drill-downs
- [ ] AI Insights v2 (richer heuristics)

- [ ] Phase 13: Settings/Admin – Company settings UI (timezone/currency/lang)
- [ ] Role/permission admin UI; audit logs viewer (`activity_logs`, `system_logs`)

- [ ] Phase 14: Security – CSRF tokens, validation, CORS tighten, prepared statements review
- [ ] File upload hardening (extensions, size, virus scan hook), private storage
- [ ] CSP, rate limiting, password policy

- [ ] Phase 15: Testing & QA – Postman collection, smoke tests for APIs
- [ ] Seed scripts and demo dataset loader
- [ ] Optional PHPUnit for critical endpoints

- [ ] Phase 16: Theming – Integrate Kaiadmin Lite across all pages

- [ ] Phase 17: Documentation – README, Admin/User guides, architecture diagram

---

## Immediate Next Actions
- Build User & Role Management UI (`assets/js/users.js`):
  - List users, create/activate/deactivate, assign roles, reset passwords.
- Build Organization UI pages:
  - `assets/js/branches.js`, `assets/js/positions.js`, `assets/js/subcompanies.js`.
- Leave UI upgrades (balances, approval queue): `assets/js/leave.js`.

## Milestones & Sprints (example)
- Sprint 1: Phase 1 UI + Phase 2 UI basics.
- Sprint 2: Phase 3 profile/documents + Phase 4 leave UI.
- Sprint 3: Phase 5 training approvals + Phase 6 appraisal templates.
- Sprint 4: Phase 7 payroll run + payslips.
- Sprint 5: Phase 8 attendance + Phase 11 emails.
- Sprint 6: Phase 12 analytics drill-down + Phase 13 settings/audit.
- Sprint 7: Phase 14 security + Phase 15 testing & docs.
- Sprint 8: Phase 16 theming polish + Phase 17 docs.

## Definition of Done (per phase)
- Backend endpoints implemented with prepared statements and auth checks.
- UI page(s) with role-based visibility and maker–checker actions.
- Logs and audits captured (`system_logs`, `activity_logs`) with Request ID.
- Basic tests: manual smoke via Postman; later automated.
- Security checklist: input validation, CSRF (where applicable), CORS, upload rules.

## Risks & Mitigations
- Data integrity across approvals → enforce constraints (FKs, statuses), audit logs.
- Role misconfig → role admin UI and server-side checks everywhere.
- File uploads risk → whitelists, size limits, optional scan hook.
- Performance → add indexes as data grows; simple pagination for lists.

## Directory & Naming Conventions
- APIs: `api/*.php` (REST-like via method + `action` query param).
- Frontend modules: `assets/js/<page>.js` expose `window.pages[page] = { render }`.
- Styles: `assets/css/style.css`.
- Shared helpers: `config/database.php` (DB + `ApiResponse`, `Auth`, session helpers).
- Logs: `storage/logs/app.log`.

## Current Endpoints (selection)
- Auth: `api/auth.php` (login, logout, check)
- Employees: `api/employees.php`
- Leave: `api/leave.php`
- Training: `api/training.php`
- Appraisal: `api/appraisal.php`
- Payroll: `api/payroll.php`
- Organization: `api/organization.php?entity=departments|branches|positions|sub_companies`
- Announcements: `api/announcements.php`
- Notifications: `api/notifications.php`
- Analytics: `api/analytics.php`
- Client Logs: `api/logs.php`

## Role Model (high level)
- Admin: full access; settings, roles, all HR data.
- HR Head/Lead: approve and manage HR operations; final approver.
- HR Officer: data entry and editing; no final approvals.
- Manager: approve within reporting lines; view team info.
- Employee: self-service (leave, training, profile, payslips).

---

Keep this document updated each sprint. See also the project TODO board for granular tasks and status updates.



Experience & Engagement
• Mobile PWA self‑service
Installable app, offline mode, push notifications, quick actions (clock‑in, request leave).
• Pulse surveys & eNPS
Anonymous pulses, heatmaps by department, trends, action plans.
• Recognition & kudos
Badges, leaderboards, automated birthdays/anniversaries with messages.
• “Ask HR” assistant
Chat over policies/handbook and user’s data (balances, status), with audit trail.
Performance & Learning
• Appraisal templates & KPIs per department
Weightings, cascaded goals/OKRs, calibration grid, multi‑rater/360 feedback.
• Skills matrix & gap analysis
Map roles→skills, compute gaps, auto‑recommend trainings.
• Learning paths with quizzes/certificates
Track completions; link to appraisals and promotions.
On/Off‑boarding & Workflows
• Onboarding checklists
Tasks by HR/IT/Manager/Employee, e‑signature for policies, asset handover.
• Offboarding & exit interviews
Clearance, deprovisioning steps, reason analytics.
• Letter generator
Offer/confirmation/transfer/disciplinary letters from templates with placeholders; e‑sign.
Attendance & Time
• Geofenced/QR attendance + selfie
Enforce within office/site, photo proof, audit map.
• Shift planning & rosters
Drag‑and‑drop shifts, coverage alerts, overtime approvals.
• Timesheets
Projects/activities, approvals, billable reports.
Recruitment
• Careers site + candidate portal
Apply/track status, interview scheduling, email templates.
• Resume parsing & matching
Extract fields, auto‑rank for job requirements, shortlist recommendations.
• Interview scorecards & panel feedback
Structured criteria, weighted scores, bias checks.
Payroll & Finance
• Variance analytics & simulations
Detect abnormal changes, simulate adjustments before locking.
• Bank/statutory exports
One‑click files (bank, tax/SSNIT), lock periods, retro pay handling.
• Self‑service reimbursements
Policy rules, receipt OCR, auto‑classify.
Documents, Compliance & Security
• Policy acknowledgments tracking
Who read/accepted; re‑certification cadence.
• Document lifecycle
Expiry reminders (IDs, visas, certs), secure vault per employee.
• Audit trails & RBAC hardening
Row‑level access (self/team/company), field change logs, data retention.
Analytics & Reports
• Saved & scheduled reports
Name/share with roles, email/PDF delivery, file archive.
• Pivoting, grouping, drill‑down
Totals by department/branch/grade, click to detail.
• Anomaly detection
Flag outliers (absenteeism spikes, overtime anomalies, payroll variances).
• Executive dashboards
KPIs: headcount, attrition, diversity, time‑to‑hire, training ROI, performance distributions.
Customization & Extensibility
• Custom fields & form builder
Add fields to Employee/Leave/Training etc., with validation and visibility rules.
• Rule engine
“When X then Y” automations: route approvals, send messages, set flags.
• Integrations
SSO (Microsoft/Google), Slack/Teams, calendars, biometric devices, accounting (QuickBooks), docs (SharePoint/Drive), SMS, email providers.
• Public APIs & webhooks
REST/GraphQL, sandbox tenant.
Quick wins I suggest next (low risk, high value)
• Saved reports + scheduled email/PDF (build on 
api/reports.php
 and 
assets/js/reports.js
).
• Appraisal templates with weights per department; 360 feedback step.
• Onboarding checklist with e‑sign policy acknowledgments.
• Geofenced/QR attendance for mobile.
• Letter generator with placeholders and e‑signature.



i want to implement a feature when hr offcer/hr head can upload policies,onboarding documents,hand work , or other documents etc for all staff ehich can view or download on the app or be able to select a particular employee to have restricted access to it ..make it robust and awesome feature
CREATE A SIDEBAR MENU FOR THIS FOR ALL USERS TYPES  ...also a calendar planning where HR officer/hr head will plan all the activities on month or year on the calendar and appear on the dashboard calendar as on the holiday setting at the HR Settings..also notifications must be created for events when close to it as pop in the banner notifications icon