// Profile page for current logged-in user
(function(){
  window.pages = window.pages || {};

  function esc(s){ try { return String(s ?? '').replace(/[&<>"']/g, c=>({"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#39;"}[c])); } catch(_){ return String(s||''); } }
  function notify(msg, type){ try{ window.auth?.showNotification?.(msg, type||'info'); }catch(_){} }

  async function fetchProfile(){
    const r = await fetch('api/me.php?action=profile', { credentials: 'same-origin' });
    const j = await r.json();
    if (!j?.success) throw new Error(j?.message||'Failed to load profile');
    return j.data || {};
  }

  async function postJSON(action, payload){
    const r = await fetch(`api/me.php?action=${action}`, { method: 'POST', headers: { 'Content-Type': 'application/json' }, credentials: 'same-origin', body: JSON.stringify(payload||{}) });
    const j = await r.json();
    if (!j?.success) throw new Error(j?.message||'Request failed');
    return j.data;
  }

  async function refreshNavbarUser(){
    try{
      const r = await fetch('api/auth.php?action=check', { credentials:'same-origin' });
      const j = await r.json();
      if (j?.success && j.data?.user){
        window.auth.currentUser = j.data.user;
        localStorage.setItem('superbhr_user', JSON.stringify(window.auth.currentUser));
        window.auth.updateUserInfo();
      }
    }catch(_){ }
  }

  async function uploadAvatar(file){
    const fd = new FormData(); fd.append('file', file);
    const r = await fetch('api/me.php?action=upload_avatar', { method: 'POST', body: fd, credentials:'same-origin' });
    const j = await r.json(); if (!j?.success) throw new Error(j?.message||'Upload failed');
    return j.data?.avatar;
  }

  function renderForm(container, p){
    const avatar = p.avatar || 'assets/img/avatar-default.png';
    const emp = p.employee_id ? `#${p.employee_number||''}` : 'Not linked';
    const roleBadges = Array.isArray(p.roles) ? p.roles.map(r=>`<span class="badge rounded-pill bg-primary-subtle text-primary me-1">${esc(r.name||r.slug||'Role')}</span>`).join('') : '';

    container.innerHTML = `
      <div class="row g-3">
        <div class="col-lg-4">
          <div class="card h-100">
            <div class="card-body">
              <div class="text-center">
                <img id="profAvatar" src="${esc(avatar)}" class="rounded-circle mb-3" style="width:120px;height:120px;object-fit:cover;border:3px solid #1A3E73;" alt="avatar" />
                <div>
                  <label class="btn btn-sm btn-outline-primary">
                    <i class="fas fa-upload"></i> Change Avatar
                    <input id="avatarInput" type="file" accept="image/*" style="display:none" />
                  </label>
                </div>
              </div>
              <hr/>
              <div class="small text-muted mb-1">Roles</div>
              <div>${roleBadges || '<span class="text-muted">None</span>'}</div>
              <hr/>
              <div class="small text-muted mb-1">Employee</div>
              <div>${esc(emp)}</div>
              <div class="small text-muted">${esc(p.department_name||'')}${p.department_name? ' • ':''}${esc(p.position_title||'')}</div>
              ${p.hire_date? `<div class="small text-muted">Hired: ${esc(p.hire_date)}</div>`:''}
            </div>
          </div>
        </div>
        <div class="col-lg-8">
          <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h5 class="mb-0">My Profile</h5>
              <button class="btn btn-sm btn-primary" id="btnSaveProfile"><i class="fas fa-save"></i> Save</button>
            </div>
            <div class="card-body">
              <div class="row g-3">
                <div class="col-md-6"><label class="form-label">First Name</label><input id="pfFirst" class="form-control" value="${esc(p.first_name||'')}" /></div>
                <div class="col-md-6"><label class="form-label">Last Name</label><input id="pfLast" class="form-control" value="${esc(p.last_name||'')}" /></div>
                <div class="col-md-6"><label class="form-label">Username</label><input id="pfUser" class="form-control" value="${esc(p.username||'')}" /></div>
                <div class="col-md-6"><label class="form-label">Email</label><input id="pfEmail" type="email" class="form-control" value="${esc(p.email||'')}" /></div>
                <div class="col-md-6"><label class="form-label">Phone</label><input id="pfPhone" class="form-control" value="${esc(p.phone||'')}" /></div>
              </div>
            </div>
          </div>
          <div class="card mt-3">
            <div class="card-header"><h6 class="mb-0">Change Password</h6></div>
            <div class="card-body">
              <div class="row g-3">
                <div class="col-md-4"><label class="form-label">Current Password</label><input id="pwCurrent" type="password" class="form-control" /></div>
                <div class="col-md-4"><label class="form-label">New Password</label><input id="pwNew" type="password" class="form-control" /></div>
                <div class="col-md-4"><label class="form-label">Confirm Password</label><input id="pwConfirm" type="password" class="form-control" /></div>
              </div>
              <div class="text-end mt-3"><button class="btn btn-outline-primary" id="btnChangePw"><i class="fas fa-key"></i> Update Password</button></div>
            </div>
          </div>
        </div>
      </div>`;

    // Bind avatar upload
    const inFile = container.querySelector('#avatarInput');
    const img = container.querySelector('#profAvatar');
    if (inFile && !inFile._bound){ inFile._bound = true; inFile.addEventListener('change', async (e)=>{
      const f = e.target.files?.[0]; if (!f) return; try{ const url = await uploadAvatar(f); if (img) img.src = url; await refreshNavbarUser(); notify('Avatar updated','success'); }catch(err){ notify(String(err.message||err),'error'); }
    }); }

    // Bind save profile
    const btnSave = container.querySelector('#btnSaveProfile');
    if (btnSave && !btnSave._bound){ btnSave._bound = true; btnSave.addEventListener('click', async()=>{
      const payload = {
        first_name: container.querySelector('#pfFirst')?.value?.trim()||'',
        last_name: container.querySelector('#pfLast')?.value?.trim()||'',
        username: container.querySelector('#pfUser')?.value?.trim()||'',
        email: container.querySelector('#pfEmail')?.value?.trim()||'',
        phone: container.querySelector('#pfPhone')?.value?.trim()||''
      };
      try{ await postJSON('update_profile', payload); await refreshNavbarUser(); notify('Profile updated','success'); }
      catch(err){ notify(String(err.message||err),'error'); }
    }); }

    // Bind change password
    const btnPw = container.querySelector('#btnChangePw');
    if (btnPw && !btnPw._bound){ btnPw._bound = true; btnPw.addEventListener('click', async()=>{
      const cur = container.querySelector('#pwCurrent')?.value||'';
      const nw = container.querySelector('#pwNew')?.value||'';
      const cf = container.querySelector('#pwConfirm')?.value||'';
      if (!cur || !nw){ notify('Enter current and new password','warning'); return; }
      if (nw !== cf){ notify('New password and confirmation do not match','warning'); return; }
      try{ await postJSON('change_password', { current_password: cur, new_password: nw });
        container.querySelector('#pwCurrent').value = '';
        container.querySelector('#pwNew').value = '';
        container.querySelector('#pwConfirm').value = '';
        notify('Password updated','success');
      }catch(err){ notify(String(err.message||err),'error'); }
    }); }
  }

  window.pages.profile = {
    async render(container){
      container.innerHTML = '<div class="d-flex justify-content-center align-items-center" style="min-height:160px"><div class="spinner"></div><span class="ms-2">Loading profile...</span></div>';
      try{
        const prof = await fetchProfile();
        renderForm(container, prof);
      }catch(err){
        container.innerHTML = `<div class="alert alert-danger">${esc(err.message||err)}</div>`;
      }
    }
  };
})();
