// Planner page (company events)
(function(){
  window.pages = window.pages || {};

  const notify = (m,t)=> window.auth?.showNotification?.(m,t||'info');
  const esc = s=> String(s??'').replace(/[&<>"']/g,c=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;','\'':'&#39;'}[c]));
  const isHr = ()=> ['super_admin','admin','hr_head','hr_officer'].includes((window.auth?.currentUser?.role_slug)||window.auth?.currentUser?.role);

  async function render(container){
    container.innerHTML = `
      <div class="card mb-3">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="mb-0">Planner</h5>
          <div class="d-flex gap-2">
            ${isHr()? '<button class="btn btn-sm btn-primary" id="plNew"><i class="fas fa-plus"></i> New Event</button>':''}
            <input type="date" class="form-control form-control-sm" id="plFrom" style="width: auto;" />
            <input type="date" class="form-control form-control-sm" id="plTo" style="width: auto;" />
            <button class="btn btn-sm btn-outline-secondary" id="plReload"><i class="fas fa-rotate"></i></button>
          </div>
        </div>
        <div class="card-body">
          <div id="plList" class="table-responsive"></div>
        </div>
      </div>`;

    // date defaults
    const now = new Date();
    const y = now.getFullYear(), m = now.getMonth();
    const first = new Date(y,m,1), last = new Date(y,m+1,0);
    document.getElementById('plFrom').value = `${y}-${String(m+1).padStart(2,'0')}-01`;
    document.getElementById('plTo').value = `${y}-${String(m+1).padStart(2,'0')}-${String(last.getDate()).padStart(2,'0')}`;

    document.getElementById('plReload').addEventListener('click', loadList);
    if (isHr()) document.getElementById('plNew').addEventListener('click', ()=> editEvent(null));

    loadList();
  }

  async function loadList(){
    const from = document.getElementById('plFrom').value;
    const to = document.getElementById('plTo').value;
    const wrap = document.getElementById('plList');
    wrap.innerHTML = '<div class="p-3">Loading...</div>';
    try{
      const res = await fetch(`api/calendar.php?action=range&from=${from}&to=${to}`, { credentials:'same-origin' });
      const js = await res.json();
      const rows = js?.success ? (js.data||[]) : [];
      if (!rows.length){ wrap.innerHTML = '<div class="text-muted p-3">No events</div>'; return; }
      wrap.innerHTML = `
        <table class="table table-sm align-middle">
          <thead><tr><th>Title</th><th>Start</th><th>End</th><th>Visibility</th><th>Reminder</th>${isHr()?'<th style="width:160px">Actions</th>':''}</tr></thead>
          <tbody>
            ${rows.map(r=> `
              <tr>
                <td>${esc(r.title||'')}<div class="small text-muted">${esc(r.description||'')}</div></td>
                <td>${esc(formatDt(r.start_at))}</td>
                <td>${esc(r.end_at?formatDt(r.end_at):'-')}</td>
                <td>${esc(r.visibility||'')}</td>
                <td>${Number(r.reminder_minutes||0)} min before</td>
                ${isHr()? `<td><div class="btn-group btn-group-sm"><button class="btn btn-outline-primary" data-e="edit" data-id="${r.id}"><i class="fas fa-pen"></i></button><button class="btn btn-outline-danger" data-e="del" data-id="${r.id}"><i class="fas fa-trash"></i></button></div></td>`:''}
              </tr>`).join('')}
          </tbody>
        </table>`;
      if (isHr()){
        wrap.querySelectorAll('[data-e]')?.forEach(btn=>{
          btn.addEventListener('click', ()=>{
            const id = Number(btn.getAttribute('data-id'));
            const act = btn.getAttribute('data-e');
            if (act==='edit') editEvent(id);
            else if (act==='del') delEvent(id);
          });
        });
      }
    }catch(_){ wrap.innerHTML = '<div class="text-danger p-3">Failed to load</div>'; }
  }

  async function delEvent(id){
    if (!confirm('Delete this event?')) return;
    try{
      const res = await fetch('api/calendar.php?action=delete', { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'same-origin', body: JSON.stringify({ id }) });
      const js = await res.json();
      if (js?.success){ notify('Deleted','success'); loadList(); }
      else notify(js?.message||'Delete failed','error');
    }catch(_){ notify('Delete failed','error'); }
  }

  async function editEvent(id){
    const overlay = document.createElement('div');
    overlay.className = 'modal fade show'; overlay.style.display='block';
    overlay.innerHTML = `
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header"><h5 class="modal-title">${id? 'Edit':'New'} Event</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
          <div class="modal-body">
            <div class="mb-2"><label class="form-label">Title</label><input class="form-control" id="evTitle"/></div>
            <div class="mb-2"><label class="form-label">Description</label><textarea class="form-control" id="evDesc" rows="3"></textarea></div>
            <div class="row g-2">
              <div class="col-md-6"><label class="form-label">Start</label><input type="datetime-local" class="form-control" id="evStart"/></div>
              <div class="col-md-6"><label class="form-label">End</label><input type="datetime-local" class="form-control" id="evEnd"/></div>
            </div>
            <div class="row g-2 mt-1">
              <div class="col-md-6"><label class="form-label">Visibility</label><select class="form-select" id="evVis"><option value="all">All employees</option><option value="selected">Selected employees</option></select></div>
              <div class="col-md-6"><label class="form-label">Reminder (minutes)</label><input type="number" min="0" class="form-control" id="evRem" value="60"/></div>
            </div>
            <div id="evSelWrap" style="display:none;" class="mt-2">
              <label class="form-label">Selected Employees</label>
              <div class="input-group">
                <input class="form-control" id="evEmpQ" placeholder="Search employee..." />
                <button class="btn btn-outline-secondary" id="evEmpAdd">Add</button>
              </div>
              <div class="small text-muted">Selected: <span id="evCount">0</span></div>
              <div id="evList" class="mt-2" style="max-height:160px; overflow:auto;"></div>
            </div>
          </div>
          <div class="modal-footer"><button class="btn btn-light" data-bs-dismiss="modal">Close</button><button class="btn btn-primary" id="evSave">Save</button></div>
        </div>
      </div>`;
    document.body.appendChild(overlay);
    const bs = new bootstrap.Modal(overlay); bs.show();

    const selWrap = overlay.querySelector('#evSelWrap');
    const vis = overlay.querySelector('#evVis');
    const evList = overlay.querySelector('#evList');
    const evCount = overlay.querySelector('#evCount');
    let selected = [];

    vis.addEventListener('change', ()=>{ selWrap.style.display = vis.value==='selected' ? '' : 'none'; });
    overlay.querySelector('#evEmpAdd').addEventListener('click', async ()=>{
      const q = overlay.querySelector('#evEmpQ').value.trim(); if (q.length<2){ notify('Type at least 2 characters','warning'); return; }
      try{
        const res = await fetch('api/documents.php?action=employees&q='+encodeURIComponent(q), { credentials:'same-origin' });
        const js = await res.json();
        const rows = js?.success ? (js.data||[]) : [];
        evList.innerHTML = rows.map(r=> `<button class="btn btn-sm btn-outline-primary me-2 mb-2" data-add="${r.id}" data-name="${esc((r.first_name||'')+' '+(r.last_name||''))}"><i class="fas fa-user-plus"></i> ${esc((r.first_name||'')+' '+(r.last_name||''))}</button>`).join('') || '<div class="text-muted">No matches</div>';
        evList.querySelectorAll('[data-add]')?.forEach(btn=> btn.addEventListener('click', ()=>{ const id=Number(btn.getAttribute('data-add')); const name=btn.getAttribute('data-name'); if (!selected.some(x=>x.id===id)){ selected.push({id,name}); evCount.textContent=String(selected.length);} }));
      }catch(_){ evList.innerHTML = '<div class="text-danger">Search failed</div>'; }
    });

    overlay.querySelector('#evSave').addEventListener('click', async ()=>{
      const payload = {
        id: id||0,
        title: overlay.querySelector('#evTitle').value.trim(),
        description: overlay.querySelector('#evDesc').value.trim(),
        start_at: overlay.querySelector('#evStart').value.replace('T',' '),
        end_at: overlay.querySelector('#evEnd').value ? overlay.querySelector('#evEnd').value.replace('T',' ') : null,
        visibility: vis.value,
        reminder_minutes: Number(overlay.querySelector('#evRem').value||60),
        selected_employees: selected.map(x=>x.id)
      };
      if (!payload.title){ notify('Title required','warning'); return; }
      if (!payload.start_at){ notify('Start required','warning'); return; }
      try{
        const res = await fetch('api/calendar.php?action=save', { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'same-origin', body: JSON.stringify(payload) });
        const js = await res.json();
        if (js?.success){ notify(id? 'Updated':'Created','success'); bs.hide(); setTimeout(()=>overlay.remove(),300); loadList(); }
        else notify(js?.message||'Save failed','error');
      }catch(_){ notify('Save failed','error'); }
    });

    overlay.querySelector('[data-bs-dismiss="modal"]').addEventListener('click', ()=>{ bs.hide(); setTimeout(()=>overlay.remove(),300); });
  }

  function formatDt(s){ try{ const d=new Date(s.replace(' ','T')); return d.toLocaleString(); }catch(_){ return s; } }

  window.pages.planner = { render };
})();
