// My Payslips page - lists only current user's payslips
(function(){
  window.pages = window.pages || {};

  function currency(v){ const n = Number(v||0); return Number.isNaN(n) ? String(v||'') : n.toFixed(2); }
  function escapeHtml(s){ return String(s ?? '').replace(/[&<>"']/g, c=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;','\'':'&#39;'}[c])); }

  async function fetchMyPayslips(){
    try {
      const res = await fetch('api/payroll.php?action=my_payslips', { credentials:'same-origin' });
      const json = await res.json();
      return json?.success ? (json.data || []) : [];
    } catch(_) { return []; }
  }

  async function render(container){
    container.innerHTML = `
      <div class="card">
        <div class="card-body">
          <h5 class="card-title mb-3">My Payslips</h5>
          <div id="myPayslipsList">Loading...</div>
        </div>
      </div>`;
    const wrap = container.querySelector('#myPayslipsList');
    const rows = await fetchMyPayslips();
    if (!Array.isArray(rows) || rows.length === 0){
      wrap.innerHTML = '<div class="text-muted">No payslips available yet.</div>';
      return;
    }
    const bodyRows = rows.map(p=>{
      const period = `${escapeHtml(p.pay_period_start || '')} - ${escapeHtml(p.pay_period_end || '')}`;
      const net = currency(p.net_salary);
      const status = escapeHtml(p.status || '');
      const id = p.id;
      return `<tr data-id="${id}">
        <td>${period}</td>
        <td class="text-end">${net}</td>
        <td>${status}</td>
        <td>
          <button class="btn btn-sm btn-outline-primary me-1" data-action="view" data-id="${id}">View Payslip</button>
          <button class="btn btn-sm btn-primary" data-action="pdf" data-id="${id}">Download PDF</button>
        </td>
      </tr>`;
    }).join('');

    wrap.innerHTML = `<div class="table-responsive">
      <table class="table table-sm">
        <thead><tr><th>Period</th><th class="text-end">Net</th><th>Status</th><th style="width:220px">Actions</th></tr></thead>
        <tbody>${bodyRows}</tbody>
      </table>
    </div>`;

    wrap.addEventListener('click', async (e)=>{
      const btn = e.target.closest('button[data-action]');
      if (!btn) return;
      const id = btn.getAttribute('data-id');
      const action = btn.getAttribute('data-action');
      try {
        window.logEvent?.('info', 'payslip_open_clicked', { id, action });
        const url = `api/payroll.php?action=payslip_html&id=${encodeURIComponent(id)}${action==='pdf' ? '&print=1' : ''}`;
        window.open(url, '_blank', 'noopener');
        window.logEvent?.('info', 'payslip_window_open_url', { id, action, url });
      } catch(_) { window.auth?.showNotification?.('Failed to open payslip', 'error'); }
    });
  }

  window.pages.mypayslips = { render };
})();
