// My Settings page for current user (language/timezone preferences)
(function(){
  window.pages = window.pages || {};
  function esc(s){ try { return String(s ?? '').replace(/[&<>"']/g, c=>({"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#39;"}[c])); } catch(_){ return String(s||''); } }
  function notify(msg, type){ try{ window.auth?.showNotification?.(msg, type||'info'); }catch(_){} }

  async function loadSettings(){
    const r = await fetch('api/me.php?action=settings', { credentials:'same-origin' });
    const j = await r.json(); if (!j?.success) throw new Error(j?.message||'Failed to load settings');
    return j.data || {};
  }

  async function saveSettings(payload){
    const r = await fetch('api/me.php?action=update_settings', { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'same-origin', body: JSON.stringify(payload||{}) });
    const j = await r.json(); if (!j?.success) throw new Error(j?.message||'Failed to save');
    return true;
  }

  function tzOptions(){
    // Minimal curated list; can be expanded or loaded dynamically later
    return [
      'UTC','Africa/Accra','Africa/Lagos','Africa/Nairobi','Europe/London','Europe/Berlin','Europe/Paris','Asia/Dubai','Asia/Kolkata','Asia/Singapore','Asia/Tokyo','America/New_York','America/Los_Angeles'
    ];
  }

  function langOptions(){ return ['en','fr','es','de','pt']; }

  function renderForm(container, s){
    const langs = langOptions(); const tzs = tzOptions();
    container.innerHTML = `
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="mb-0">My Settings</h5>
          <button class="btn btn-sm btn-primary" id="btnSaveSettings"><i class="fas fa-save"></i> Save</button>
        </div>
        <div class="card-body">
          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">Language</label>
              <select id="setLang" class="form-select">
                ${langs.map(l=>`<option value="${l}" ${s.language===l?'selected':''}>${l.toUpperCase()}</option>`).join('')}
              </select>
            </div>
            <div class="col-md-6">
              <label class="form-label">Timezone</label>
              <select id="setTz" class="form-select">
                ${tzs.map(z=>`<option value="${esc(z)}" ${s.timezone===z?'selected':''}>${esc(z)}</option>`).join('')}
              </select>
            </div>
          </div>
        </div>
      </div>`;

    const btn = container.querySelector('#btnSaveSettings');
    if (btn && !btn._bound){ btn._bound = true; btn.addEventListener('click', async()=>{
      const payload = { language: container.querySelector('#setLang')?.value || null, timezone: container.querySelector('#setTz')?.value || null };
      try{ await saveSettings(payload); notify('Settings saved','success'); }catch(err){ notify(String(err.message||err),'error'); }
    }); }
  }

  window.pages.settings = {
    async render(container){
      container.innerHTML = '<div class="d-flex justify-content-center align-items-center" style="min-height:160px"><div class="spinner"></div><span class="ms-2">Loading settings...</span></div>';
      try{ const s = await loadSettings(); renderForm(container, s); }catch(err){ container.innerHTML = `<div class="alert alert-danger">${esc(err.message||err)}</div>`; }
    }
  };
})();
