// My Messages page
(function(){
  window.pages = window.pages || {};

  const esc = s=>{ try{ return String(s).replace(/[&<>"']/g,c=>({"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#39;"}[c])); }catch(_){ return String(s||''); } };
  const notify = (m,t)=>{ try{ window.auth?.showNotification?.(m,t||'info'); }catch(_){} };

  function fullName(fn, ln, un){
    const nm = [fn||'', ln||''].join(' ').trim();
    return nm || (un||'');
  }

  function formatWhen(ts){
    if (!ts) return '';
    try{ const d = new Date(ts.replace(' ','T')); return d.toLocaleString(); }catch(_){ return ts; }
  }

  async function render(container){
    container.innerHTML = `
      <div class="row g-3">
        <div class="col-lg-8">
          <div class="card mb-3">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h6 class="mb-0">Inbox</h6>
              <button class="btn btn-sm btn-outline-secondary" id="msgRefresh"><i class="fas fa-rotate"></i> Refresh</button>
            </div>
            <div class="card-body p-0">
              <ul class="list-group list-group-flush" id="inboxList">
                <li class="list-group-item text-muted">Loading...</li>
              </ul>
            </div>
          </div>

          <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
              <h6 class="mb-0">Sent</h6>
              <button class="btn btn-sm btn-outline-secondary" id="sentRefresh"><i class="fas fa-rotate"></i> Refresh</button>
            </div>
            <div class="card-body p-0">
              <ul class="list-group list-group-flush" id="sentList">
                <li class="list-group-item text-muted">Loading...</li>
              </ul>
            </div>
          </div>
        </div>
        <div class="col-lg-4">
          <div class="card h-100">
            <div class="card-header"><h6 class="mb-0">Compose Message</h6></div>
            <div class="card-body">
              <div class="mb-2">
                <label class="form-label">Recipient</label>
                <input type="text" class="form-control" id="msgSearch" placeholder="Search employee by name, username, or department" autocomplete="off" />
                <div class="list-group mt-1" id="searchResults" style="max-height:200px; overflow:auto;"></div>
                <div class="form-text" id="selectedRec" data-id="">No recipient selected</div>
              </div>
              <div class="mb-2">
                <label class="form-label">Subject</label>
                <input type="text" class="form-control" id="msgSubject" placeholder="Subject (optional)" />
              </div>
              <div class="mb-3">
                <label class="form-label">Message</label>
                <textarea class="form-control" id="msgContent" rows="5" placeholder="Write your message..."></textarea>
              </div>
              <div class="text-end">
                <button class="btn btn-primary" id="msgSend"><i class="fas fa-paper-plane"></i> Send</button>
              </div>
            </div>
          </div>
        </div>
      </div>

      <!-- View Modal -->
      <div class="modal fade" id="viewMsgModal" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-scrollable">
          <div class="modal-content">
            <div class="modal-header">
              <h5 class="modal-title" id="vmTitle">Message</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <div class="mb-1 text-muted small" id="vmMeta"></div>
              <div id="vmBody"></div>
            </div>
          </div>
        </div>
      </div>
    `;

    // Load lists
    await Promise.all([loadInbox(container), loadSent(container)]);

    container.querySelector('#msgRefresh')?.addEventListener('click', ()=>loadInbox(container));
    container.querySelector('#sentRefresh')?.addEventListener('click', ()=>loadSent(container));
    setupSearch(container);
    container.querySelector('#msgSend')?.addEventListener('click', ()=>send(container));
  }

  async function loadInbox(container){
    const ul = container.querySelector('#inboxList'); if (!ul) return;
    ul.innerHTML = '<li class="list-group-item text-muted">Loading...</li>';
    try{
      const res = await fetch('api/messages.php?action=inbox', { credentials:'same-origin' });
      const js = await res.json();
      const rows = js?.success ? (js.data||[]) : [];
      ul.innerHTML = rows.length ? rows.map(r=>{
        const nm = esc(fullName(r.sender_first_name, r.sender_last_name, r.sender_username));
        const subj = esc(r.subject||'');
        const body = esc(r.content||'');
        const when = esc(formatWhen(r.created_at));
        const unread = !r.read_at;
        return `<li class="list-group-item ${unread?'fw-semibold':''}" data-mid="${r.id}">
          <div class="d-flex justify-content-between align-items-start">
            <div>
              <div>${nm}${subj?` — <span class="text-muted">${subj}</span>`:''}</div>
              <div class="small text-muted">${body.slice(0,120)}${body.length>120?'…':''}</div>
            </div>
            <div class="small text-nowrap text-muted">${when}</div>
          </div>
        </li>`;
      }).join('') : '<li class="list-group-item text-muted">No messages.</li>';
      // bind open
      ul.querySelectorAll('[data-mid]')?.forEach(li=>{
        li.addEventListener('click', ()=>openMessage(container, Number(li.getAttribute('data-mid')), 'inbox'));
      });
    }catch(_){ ul.innerHTML = '<li class="list-group-item text-danger">Failed to load inbox.</li>'; }
  }

  async function loadSent(container){
    const ul = container.querySelector('#sentList'); if (!ul) return;
    ul.innerHTML = '<li class="list-group-item text-muted">Loading...</li>';
    try{
      const res = await fetch('api/messages.php?action=sent', { credentials:'same-origin' });
      const js = await res.json();
      const rows = js?.success ? (js.data||[]) : [];
      ul.innerHTML = rows.length ? rows.map(r=>{
        const nm = esc(fullName(r.recipient_first_name, r.recipient_last_name, r.recipient_username));
        const subj = esc(r.subject||'');
        const body = esc(r.content||'');
        const when = esc(formatWhen(r.created_at));
        return `<li class="list-group-item" data-mid="${r.id}">
          <div class="d-flex justify-content-between align-items-start">
            <div>
              <div>To: ${nm}${subj?` — <span class=\"text-muted\">${subj}</span>`:''}</div>
              <div class="small text-muted">${body.slice(0,120)}${body.length>120?'…':''}</div>
            </div>
            <div class="small text-nowrap text-muted">${when}</div>
          </div>
        </li>`;
      }).join('') : '<li class="list-group-item text-muted">No sent messages.</li>';
      // bind open
      ul.querySelectorAll('[data-mid]')?.forEach(li=>{
        li.addEventListener('click', ()=>openMessage(container, Number(li.getAttribute('data-mid')), 'sent'));
      });
    }catch(_){ ul.innerHTML = '<li class="list-group-item text-danger">Failed to load sent messages.</li>'; }
  }

  function setupSearch(container){
    const input = container.querySelector('#msgSearch');
    const list = container.querySelector('#searchResults');
    const sel = container.querySelector('#selectedRec');
    let t = null;
    input?.addEventListener('input', ()=>{
      const q = input.value.trim();
      // reset selection
      sel.textContent = q ? 'Searching…' : 'No recipient selected';
      sel.dataset.id = '';
      if (t) clearTimeout(t);
      if (q.length < 2){ list.innerHTML = ''; return; }
      t = setTimeout(async ()=>{
        try{
          const res = await fetch('api/messages.php?action=recipients&q='+encodeURIComponent(q), { credentials:'same-origin' });
          const js = await res.json();
          const rows = js?.success ? (js.data||[]) : [];
          list.innerHTML = rows.length ? rows.map(r=>{
            const name = esc(fullName(r.first_name, r.last_name, r.username));
            const dep = esc(r.department_name||'');
            return `<button type="button" class="list-group-item list-group-item-action" data-rec="${r.id}" data-name="${name}">${name}${dep?` <span class=\"small text-muted\">(${dep})</span>`:''}</button>`;
          }).join('') : '<div class="list-group-item text-muted">No matches</div>';
          list.querySelectorAll('[data-rec]')?.forEach(btn=>{
            btn.addEventListener('click', ()=>{
              sel.dataset.id = btn.getAttribute('data-rec');
              sel.textContent = 'Selected: ' + btn.getAttribute('data-name');
              list.innerHTML='';
              input.value='';
            });
          });
        }catch(_){ list.innerHTML = '<div class="list-group-item text-danger">Search failed</div>'; }
      }, 250);
    });
  }

  async function send(container){
    const sel = container.querySelector('#selectedRec');
    const toId = Number(sel?.dataset?.id||0);
    const subj = container.querySelector('#msgSubject')?.value?.trim() || '';
    const body = container.querySelector('#msgContent')?.value?.trim() || '';
    if (!toId){ notify('Please select a recipient','warning'); return; }
    if (!body){ notify('Please enter a message','warning'); return; }
    try{
      const r = await fetch('api/messages.php?action=send', { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'same-origin', body: JSON.stringify({ recipient_user_id: toId, subject: subj||'Message', content: body }) });
      const j = await r.json();
      if (j?.success){
        notify('Message sent','success');
        container.querySelector('#msgSubject').value='';
        container.querySelector('#msgContent').value='';
        sel.textContent='No recipient selected'; sel.dataset.id='';
        loadSent(container);
      } else notify(j?.message||'Send failed','error');
    }catch(_){ notify('Send failed','error'); }
  }

  async function openMessage(container, id, box){
    // Since we don't have a specific view endpoint, fetch list and find
    try{
      const url = box==='sent' ? 'api/messages.php?action=sent' : 'api/messages.php?action=inbox';
      const res = await fetch(url, { credentials:'same-origin' });
      const js = await res.json();
      const rows = js?.success ? (js.data||[]) : [];
      const msg = rows.find(m=>Number(m.id)===Number(id));
      if (!msg) return;
      // mark read for inbox
      if (box!=='sent' && !msg.read_at){
        try{ await fetch('api/messages.php?action=mark_read', { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'same-origin', body: JSON.stringify({ id }) }); }catch(_){ }
      }
      const title = document.getElementById('vmTitle');
      const meta = document.getElementById('vmMeta');
      const body = document.getElementById('vmBody');
      if (title) title.textContent = (msg.subject||'Message');
      const name = box==='sent' ? fullName(msg.recipient_first_name, msg.recipient_last_name, msg.recipient_username) : fullName(msg.sender_first_name, msg.sender_last_name, msg.sender_username);
      if (meta) meta.textContent = `${box==='sent'?'To':'From'} ${name} • ${formatWhen(msg.created_at)}`;
      if (body) body.textContent = msg.content || '';
      const modalEl = document.getElementById('viewMsgModal');
      if (modalEl) bootstrap.Modal.getOrCreateInstance(modalEl).show();
      // refresh inbox to remove bold
      if (box!=='sent') loadInbox(container);
    }catch(_){ /* ignore */ }
  }

  window.pages.messages = { render };
})();
