// Function to render the allocations grid with input fields
function renderAllocationsGrid() {
    const gridContainer = document.getElementById('allocations-grid'); // Adjust ID as needed
    if (!gridContainer) return; // Exit if element not found
    gridContainer.innerHTML = ''; // Clear existing content

    // Create header row with leave types
    const headerRow = document.createElement('tr');
    headerRow.innerHTML = '<th>Grade</th>'; // First column for grades
    leave_types.forEach(type => {
        headerRow.innerHTML += `<th>${type.name}</th>`;
    });
    gridContainer.appendChild(headerRow);

    // Create rows for each grade
    grades.forEach(grade => {
        const row = document.createElement('tr');
        row.innerHTML = `<td>${grade}</td>`; // Grade name

        leave_types.forEach(type => {
            // Find existing allocation or default to 0
            const existingAlloc = allocations.find(a => a.grade === grade && a.leave_type_id === type.id);
            const days = existingAlloc ? existingAlloc.days_per_year : 0;

            // Create editable input field
            const cell = document.createElement('td');
            const input = document.createElement('input');
            input.type = 'number';
            input.min = '0';
            input.value = days;
            input.className = 'form-control'; // Add styling as needed
            input.dataset.grade = grade;
            input.dataset.leaveTypeId = type.id;
            input.addEventListener('change', handleAllocationChange);
            cell.appendChild(input);
            row.appendChild(cell);
        });

        gridContainer.appendChild(row);
    });
}

// Function to handle input changes and save
function handleAllocationChange(event) {
    const input = event.target;
    const grade = input.dataset.grade;
    const leaveTypeId = parseInt(input.dataset.leaveTypeId);
    const days = parseInt(input.value) || 0;

    // Update the allocations array
    const allocIndex = allocations.findIndex(a => a.grade === grade && a.leave_type_id === leaveTypeId);
    if (allocIndex >= 0) {
        allocations[allocIndex].days_per_year = days;
    } else {
        allocations.push({ grade, leave_type_id: leaveTypeId, days_per_year: days });
    }

    // Save to backend (debounce if needed for performance)
    saveAllocations();
}

// Function to save allocations via API
function saveAllocations() {
    fetch('/newsuperbhr/api/leave.php?action=save_allocations', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ allocations })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            console.log('Allocations saved successfully');
            // Optionally show a success message
        } else {
            alert('Error saving allocations: ' + data.message);
        }
    })
    .catch(error => console.error('Error:', error));
}
