// Email Settings page (Admin only)
(function(){
  window.pages = window.pages || {};

  function isAdmin(){ const u = window.auth?.currentUser; const r = u?.role_slug || u?.role; return r === 'admin' || r === 'super_admin'; }
  function isSuperAdmin(){ const u = window.auth?.currentUser; const r = u?.role_slug || u?.role; return r === 'super_admin'; }

  async function render(container){
    if (!isAdmin()) { container.innerHTML = '<div class="alert alert-warning">Access denied. Email Settings are available to Admins only.</div>'; return; }
    const superAdmin = isSuperAdmin();
    let selectedCompanyId = superAdmin ? (window.pages.email_settings.__lastCompanyId || window.auth?.currentUser?.company_id || null) : (window.auth?.currentUser?.company_id || null);
    function companyQuery(){ return superAdmin && selectedCompanyId ? '&company_id='+encodeURIComponent(selectedCompanyId) : ''; }

    container.innerHTML = `
      <div id="adminCompanyRow" class="card mb-3" style="display:none">
        <div class="card-body">
          <div class="row g-3 align-items-end">
            <div class="col-md-6">
              <label class="form-label">Company</label>
              <select class="form-select" id="companySelect">
                <option value="">Loading companies...</option>
              </select>
            </div>
            <div class="col-md-6 text-muted small">Select a company to manage its Email/SMS settings.</div>
          </div>
        </div>
      </div>
      <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="mb-0">Email Settings (SMTP)</h5>
          <small class="text-muted">Outgoing mail configuration</small>
        </div>
        <div class="card-body">
          <div class="row g-3">
            <div class="col-md-6">
              <label class="form-label">SMTP Host</label>
              <input class="form-control" id="smtpHost" placeholder="smtp.example.com" />
            </div>
            <div class="col-md-3">
              <label class="form-label">Port</label>
              <input class="form-control" id="smtpPort" type="number" placeholder="587" />
            </div>
            <div class="col-md-3">
              <label class="form-label">Encryption</label>
              <select id="smtpSecure" class="form-select">
                <option value="">None</option>
                <option value="tls" selected>TLS</option>
                <option value="ssl">SSL</option>
              </select>
            </div>
            <div class="col-md-6">
              <label class="form-label">Username</label>
              <input class="form-control" id="smtpUser" placeholder="user@example.com" />
            </div>
            <div class="col-md-6">
              <label class="form-label">Password</label>
              <input class="form-control" id="smtpPass" type="password" placeholder="••••••••" />
            </div>
            <div class="col-md-6">
              <label class="form-label">From Name</label>
              <input class="form-control" id="fromName" placeholder="SmartQuantumHR" value="SmartQuantumHR" />
            </div>
            <div class="col-md-6">
              <label class="form-label">From Email</label>
              <input class="form-control" id="fromEmail" placeholder="no-reply@yourcompany.com" />
            </div>
          </div>
          <div class="mt-3 d-flex gap-2">
            <button class="btn btn-primary" id="btnSaveEmail">Save Settings</button>
            <div class="ms-auto d-flex gap-2">
              <input class="form-control" id="testTo" placeholder="test recipient" style="max-width:280px"/>
              <button class="btn btn-outline-secondary" id="btnTestEmail">Send Test</button>
            </div>
          </div>
        </div>
      </div>

      <div class="card mt-4">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="mb-0">SMS Settings (mNotify)</h5>
          <small class="text-muted">Optional SMS notifications</small>
        </div>
        <div class="card-body">
          <div class="row g-3">
            <div class="col-md-3">
              <label class="form-label d-block">Enable SMS</label>
              <div class="form-check form-switch">
                <input class="form-check-input" type="checkbox" id="smsEnabled" />
                <label class="form-check-label" for="smsEnabled">Enabled</label>
              </div>
            </div>
            <div class="col-md-3">
              <label class="form-label">Provider</label>
              <select id="smsProvider" class="form-select" disabled>
                <option value="mnotify" selected>mNotify</option>
              </select>
            </div>
            <div class="col-md-3">
              <label class="form-label">Sender ID</label>
              <input class="form-control" id="smsSender" placeholder="SMARTQHR" />
            </div>
            <div class="col-md-3">
              <label class="form-label">API Key</label>
              <input class="form-control" id="smsApiKey" type="password" placeholder="mNotify API Key" />
              <div class="form-text">Leave blank to keep existing key</div>
            </div>
          </div>
          <div class="mt-3 d-flex gap-2">
            <button class="btn btn-primary" id="btnSaveSms">Save SMS Settings</button>
            <div class="ms-auto d-flex gap-2">
              <input class="form-control" id="testSmsTo" placeholder="233XXXXXXXXX" style="max-width:280px"/>
              <button class="btn btn-outline-secondary" id="btnTestSms">Send Test SMS</button>
            </div>
          </div>
        </div>
      </div>`;

    async function loadEmail(){
      try {
        const res = await fetch('api/settings.php?action=email'+companyQuery(), { credentials:'same-origin' });
        const json = await res.json();
        if (json?.success && json.data){
          const d = json.data;
          container.querySelector('#smtpHost').value = d.smtp_host ?? '';
          container.querySelector('#smtpPort').value = d.smtp_port ?? '';
          container.querySelector('#smtpSecure').value = d.smtp_secure ?? '';
          container.querySelector('#smtpUser').value = d.smtp_user ?? '';
          // Password is masked; do not prefill unless present in file store without mask
          if (d.smtp_pass && !d.smtp_pass_masked) container.querySelector('#smtpPass').value = d.smtp_pass;
          container.querySelector('#fromName').value = d.email_from_name ?? 'SmartQuantumHR';
          container.querySelector('#fromEmail').value = d.email_from_email ?? '';
        }
      } catch(_) {}
    }

    async function saveEmail(){
      const payload = {
        smtp_host: container.querySelector('#smtpHost').value.trim(),
        smtp_port: container.querySelector('#smtpPort').value.trim(),
        smtp_secure: container.querySelector('#smtpSecure').value,
        smtp_user: container.querySelector('#smtpUser').value.trim(),
        smtp_pass: container.querySelector('#smtpPass').value, // empty means don't change (handled server-side)
        email_from_name: container.querySelector('#fromName').value.trim(),
        email_from_email: container.querySelector('#fromEmail').value.trim(),
      };
      if (superAdmin && selectedCompanyId) payload.company_id = selectedCompanyId;
      try {
        const res = await fetch('api/settings.php?action=email', { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'same-origin', body: JSON.stringify(payload) });
        const json = await res.json();
        if (json?.success) { window.auth?.showNotification?.('Email settings saved','success'); loadEmail(); }
        else { window.auth?.showNotification?.(json?.message || 'Failed to save','error'); }
      } catch(e){ window.auth?.showNotification?.('Failed to save','error'); }
    }

    async function loadSms(){
      try {
        const res = await fetch('api/settings.php?action=sms'+companyQuery(), { credentials:'same-origin' });
        const json = await res.json();
        if (json?.success && json.data){
          const d = json.data;
          container.querySelector('#smsEnabled').checked = !!(d.enabled);
          container.querySelector('#smsProvider').value = d.provider || 'mnotify';
          container.querySelector('#smsSender').value = d.sender_id || '';
          // Do not reveal API key; field remains blank unless user sets new
        }
      } catch(_){ /* ignore */ }
    }

    async function saveSms(){
      const payload = {
        enabled: container.querySelector('#smsEnabled').checked ? 1 : 0,
        provider: 'mnotify',
        sender_id: container.querySelector('#smsSender').value.trim(),
        api_key: container.querySelector('#smsApiKey').value.trim()
      };
      if (superAdmin && selectedCompanyId) payload.company_id = selectedCompanyId;
      try {
        const res = await fetch('api/settings.php?action=sms', { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'same-origin', body: JSON.stringify(payload) });
        const json = await res.json();
        if (json?.success) { window.auth?.showNotification?.('SMS settings saved','success'); container.querySelector('#smsApiKey').value=''; loadSms(); }
        else { window.auth?.showNotification?.(json?.message || 'Failed to save SMS','error'); }
      } catch(e){ window.auth?.showNotification?.('Failed to save SMS','error'); }
    }

    async function sendTestSms(){
      const to = container.querySelector('#testSmsTo').value.trim();
      if (!to) { window.auth?.showNotification?.('Enter a phone number (e.g., 233XXXXXXXXX)','warning'); return; }
      try {
        const body = superAdmin && selectedCompanyId ? { to, company_id: selectedCompanyId } : { to };
        const res = await fetch('api/settings.php?action=sms_test', { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'same-origin', body: JSON.stringify(body) });
        const json = await res.json();
        if (json?.success) window.auth?.showNotification?.('Test SMS sent','success'); else window.auth?.showNotification?.(json?.message || 'Test SMS failed','error');
      } catch(e){ window.auth?.showNotification?.('Test SMS failed','error'); }
    }

    async function sendTest(){
      const to = container.querySelector('#testTo').value.trim();
      if (!to) { window.auth?.showNotification?.('Enter a test recipient','warning'); return; }
      try {
        const body = superAdmin && selectedCompanyId ? { to, company_id: selectedCompanyId } : { to };
        const res = await fetch('api/settings.php?action=email_test', { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'same-origin', body: JSON.stringify(body) });
        const json = await res.json();
        if (json?.success) window.auth?.showNotification?.('Test email sent','success'); else window.auth?.showNotification?.(json?.message || 'Test failed','error');
      } catch(e){ window.auth?.showNotification?.('Test failed','error'); }
    }

    async function loadCompanies(){
      if (!superAdmin) return;
      try {
        const res = await fetch('api/superadmin.php?action=list_companies', { credentials:'same-origin' });
        const json = await res.json();
        if (json?.success && Array.isArray(json.data)){
          const sel = container.querySelector('#companySelect');
          sel.innerHTML = '';
          for (const c of json.data){
            const opt = document.createElement('option');
            opt.value = c.id;
            opt.textContent = c.name || ('Company #'+c.id);
            sel.appendChild(opt);
          }
          if (selectedCompanyId) sel.value = String(selectedCompanyId);
          container.querySelector('#adminCompanyRow').style.display = '';
          sel.addEventListener('change', ()=>{
            selectedCompanyId = sel.value ? parseInt(sel.value,10) : null;
            window.pages.email_settings.__lastCompanyId = selectedCompanyId;
            loadEmail();
            loadSms();
          });
        }
      } catch(_) { /* ignore */ }
    }

    container.querySelector('#btnSaveEmail').addEventListener('click', saveEmail);
    container.querySelector('#btnTestEmail').addEventListener('click', sendTest);
    const smsSave = container.querySelector('#btnSaveSms'); if (smsSave) smsSave.addEventListener('click', saveSms);
    const smsTest = container.querySelector('#btnTestSms'); if (smsTest) smsTest.addEventListener('click', sendTestSms);

    if (superAdmin) { await loadCompanies(); }
    loadEmail();
    loadSms();
  }

  window.pages.email_settings = { render };
})();
