// Documents Library page
(function(){
  window.pages = window.pages || {};

  function esc(s){ try { return String(s??'').replace(/[&<>"']/g, c=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;','\'':'&#39;'}[c])); } catch(_) { return String(s||''); } }
  const note = (m,t)=> window.auth?.showNotification?.(m,t||'info');

  async function render(container){
    const isHr = ['super_admin','admin','hr_head','hr_officer'].includes((window.auth?.currentUser?.role_slug)||window.auth?.currentUser?.role);
    container.innerHTML = `
      <div class="card mb-3">
        <div class="card-header d-flex justify-content-between align-items-center">
          <h5 class="mb-0">Documents Library</h5>
          <div class="d-flex gap-2">
            ${isHr? '<button class="btn btn-sm btn-primary" id="btnUpload"><i class="fas fa-upload"></i> Upload</button>':''}
            <button class="btn btn-sm btn-outline-secondary" id="btnReload"><i class="fas fa-rotate"></i></button>
          </div>
        </div>
        <div class="card-body">
          <div class="row g-2 mb-2">
            <div class="col-md-3"><input class="form-control" id="docSearch" placeholder="Search title/description/category" /></div>
            <div class="col-md-3"><input class="form-control" id="docCategory" placeholder="Filter category" /></div>
          </div>
          <div class="table-responsive">
            <table class="table table-sm align-middle">
              <thead><tr><th>Title</th><th>Category</th><th>Visibility</th><th>Size</th><th>Uploaded</th><th style="width:240px;">Actions</th></tr></thead>
              <tbody id="docBody"><tr><td colspan="6">Loading...</td></tr></tbody>
            </table>
          </div>
        </div>
      </div>

      <input type="file" id="upFile" style="display:none;" />
    `;

    document.getElementById('btnReload').addEventListener('click', loadList);
    if (isHr) document.getElementById('btnUpload').addEventListener('click', ()=>startUpload(container));
    document.getElementById('docSearch').addEventListener('input', ()=>loadList());
    document.getElementById('docCategory').addEventListener('change', ()=>loadList());

    await loadList();
  }

  async function shareDoc(id){
    // open modal to set visibility and selected employees
    const overlay = document.createElement('div');
    overlay.className = 'modal fade show'; overlay.style.display='block';
    overlay.innerHTML = `
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header"><h5 class="modal-title">Share Settings</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
          <div class="modal-body">
            <div class="mb-2">
              <label class="form-label">Visibility</label>
              <select class="form-select" id="shVis"><option value="all">All employees</option><option value="selected">Selected employees</option></select>
            </div>
            <div id="shWrap" style="display:none;">
              <div class="input-group mb-2">
                <input class="form-control" id="shEmpQ" placeholder="Search employee..." />
                <button class="btn btn-outline-secondary" id="shEmpAdd">Add</button>
              </div>
              <div class="small text-muted">Selected: <span id="shCount">0</span></div>
              <div id="shList" class="mt-2" style="max-height:160px; overflow:auto;"></div>
            </div>
          </div>
          <div class="modal-footer"><button class="btn btn-light" data-bs-dismiss="modal">Close</button><button class="btn btn-primary" id="shSave">Save</button></div>
        </div>
      </div>`;
    document.body.appendChild(overlay);
    const bs = new bootstrap.Modal(overlay); bs.show();
    const shVis = overlay.querySelector('#shVis');
    const shWrap = overlay.querySelector('#shWrap');
    const shList = overlay.querySelector('#shList');
    const shCount = overlay.querySelector('#shCount');
    let selected = [];

    shVis.addEventListener('change', ()=>{ shWrap.style.display = shVis.value==='selected' ? '' : 'none'; });
    overlay.querySelector('#shEmpAdd').addEventListener('click', async ()=>{
      const q = overlay.querySelector('#shEmpQ').value.trim(); if (q.length<2){ note('Type at least 2 characters','warning'); return; }
      try{
        const res = await fetch('api/documents.php?action=employees&q='+encodeURIComponent(q), { credentials:'same-origin' });
        const js = await res.json();
        const rows = js?.success ? (js.data||[]) : [];
        shList.innerHTML = rows.map(r=> `<button class="btn btn-sm btn-outline-primary me-2 mb-2" data-add="${r.id}" data-name="${esc((r.first_name||'')+' '+(r.last_name||''))}"><i class="fas fa-user-plus"></i> ${esc((r.first_name||'')+' '+(r.last_name||''))}</button>`).join('') || '<div class="text-muted">No matches</div>';
        shList.querySelectorAll('[data-add]')?.forEach(btn=>{
          btn.addEventListener('click', ()=>{
            const id = Number(btn.getAttribute('data-add'));
            const name = btn.getAttribute('data-name');
            if (!selected.some(x=>x.id===id)){ selected.push({ id, name }); shCount.textContent = String(selected.length); }
          });
        });
      }catch(_){ shList.innerHTML = '<div class="text-danger">Search failed</div>'; }
    });

    overlay.querySelector('#shSave').addEventListener('click', async ()=>{
      try{
        const res = await fetch('api/documents.php?action=update_access', { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'same-origin', body: JSON.stringify({ id, visibility: shVis.value, selected_employees: selected.map(x=>x.id) }) });
        const js = await res.json();
        if (js?.success){ note('Updated','success'); bs.hide(); setTimeout(()=>overlay.remove(),300); loadList(); }
        else note(js?.message||'Update failed','error');
      }catch(_){ note('Update failed','error'); }
    });

    overlay.querySelector('[data-bs-dismiss="modal"]').addEventListener('click', ()=>{ bs.hide(); setTimeout(()=>overlay.remove(),300); });
  }

  async function loadList(){
    const body = document.getElementById('docBody');
    const q = document.getElementById('docSearch')?.value?.trim() || '';
    const cat = document.getElementById('docCategory')?.value?.trim() || '';
    body.innerHTML = '<tr><td colspan="6">Loading...</td></tr>';
    const url = 'api/documents.php?q='+encodeURIComponent(q)+(cat? '&category='+encodeURIComponent(cat):'');
    try{
      const res = await fetch(url, { credentials:'same-origin' });
      const js = await res.json();
      const rows = js?.success ? (js.data||[]) : [];
      body.innerHTML = rows.map(r=> `
        <tr>
          <td>
            ${esc(r.title||'')}
            <div class="small text-muted">${esc(r.description||'')}</div>
            <div class="mt-1">
              ${r.ack_required ? `<span class="badge bg-warning text-dark me-1">Ack required${r.ack_due_at? ' by '+esc(formatWhen(r.ack_due_at)) : ''}</span>` : ''}
              ${r.acked_at ? `<span class="badge bg-success">Acknowledged ${esc(formatWhen(r.acked_at))}</span>` : (r.ack_required ? `<span class="badge bg-danger">Pending</span>` : '')}
            </div>
          </td>
          <td>${esc(r.category||'-')}</td>
          <td>${esc(r.visibility||'')}</td>
          <td>${formatSize(r.size)}</td>
          <td>${esc(formatWhen(r.created_at))}</td>
          <td>
            <div class="btn-group btn-group-sm">
              <a class="btn btn-outline-primary" href="api/documents.php?action=download&id=${r.id}"><i class="fas fa-download"></i></a>
              ${isHr() ? `<button class="btn btn-outline-secondary" data-act="share" data-id="${r.id}"><i class="fas fa-user-shield"></i></button>` : ''}
              ${r.ack_required && !r.acked_at ? `<button class="btn btn-outline-success" data-act="ack" data-id="${r.id}"><i class="fas fa-check"></i> Acknowledge</button>` : ''}
              ${isHr() && r.ack_required ? `<button class="btn btn-outline-info" data-act="ack-status" data-id="${r.id}"><i class="fas fa-clipboard-check"></i></button>` : ''}
              ${isHr() ? `<button class="btn btn-outline-danger" data-act="del" data-id="${r.id}"><i class="fas fa-trash"></i></button>` : ''}
            </div>
          </td>
        </tr>`).join('') || '<tr><td colspan="6" class="text-muted">No documents</td></tr>';
      body.querySelectorAll('[data-act="del"]').forEach(btn=> btn.addEventListener('click', ()=> delDoc(Number(btn.getAttribute('data-id')))));
      body.querySelectorAll('[data-act="share"]').forEach(btn=> btn.addEventListener('click', ()=> shareDoc(Number(btn.getAttribute('data-id')))));
      body.querySelectorAll('[data-act="ack"]').forEach(btn=> btn.addEventListener('click', ()=> ackDoc(Number(btn.getAttribute('data-id')))));
      body.querySelectorAll('[data-act="ack-status"]').forEach(btn=> btn.addEventListener('click', ()=> viewAckStatus(Number(btn.getAttribute('data-id')))));
    }catch(_){ body.innerHTML = '<tr><td colspan="6" class="text-danger">Failed to load</td></tr>'; }
  }

  async function delDoc(id){
    if (!confirm('Archive this document?')) return;
    try{
      const res = await fetch('api/documents.php?action=delete', { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'same-origin', body: JSON.stringify({ id }) });
      const js = await res.json();
      if (js?.success) { note('Archived','success'); loadList(); } else note(js?.message||'Delete failed','error');
    }catch(_){ note('Delete failed','error'); }
  }

  function startUpload(container){
    const input = document.getElementById('upFile');
    const overlay = document.createElement('div');
    overlay.className = 'modal fade show'; overlay.style.display='block';
    overlay.innerHTML = `
      <div class="modal-dialog">
        <div class="modal-content">
          <div class="modal-header"><h5 class="modal-title">Upload Document</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
          <div class="modal-body">
            <div class="mb-2"><label class="form-label">Title</label><input class="form-control" id="upTitle" /></div>
            <div class="mb-2"><label class="form-label">Description</label><textarea class="form-control" id="upDesc" rows="3"></textarea></div>
            <div class="mb-2"><label class="form-label">Category</label><input class="form-control" id="upCat" placeholder="e.g. Policies, Onboarding, Handbook" /></div>
            <div class="mb-2">
              <label class="form-label">Visibility</label>
              <select class="form-select" id="upVis"><option value="all">All employees</option><option value="selected">Selected employees</option></select>
              <div class="form-text">Select employees only if you want to restrict access</div>
            </div>
            <div class="form-check mb-2">
              <input class="form-check-input" type="checkbox" id="upAckReq">
              <label class="form-check-label" for="upAckReq">Require acknowledgment</label>
            </div>
            <div class="mb-2" id="ackDueWrap" style="display:none;">
              <label class="form-label">Ack Due Date</label>
              <input type="datetime-local" class="form-control" id="upAckDue" />
            </div>
            <div class="mb-2" id="selWrap" style="display:none;">
              <label class="form-label">Selected Employees</label>
              <div class="input-group">
                <input class="form-control" id="empSearch" placeholder="Search employee..." />
                <button class="btn btn-outline-secondary" id="empAdd">Add</button>
              </div>
              <div class="small text-muted">Add multiple employees. Current: <span id="selCount">0</span></div>
              <div id="selList" class="mt-2" style="max-height:160px; overflow:auto;"></div>
            </div>
            <div class="mb-2"><label class="form-label">File</label><input type="file" id="upPick" class="form-control" /></div>
          </div>
          <div class="modal-footer"><button class="btn btn-light" data-bs-dismiss="modal">Close</button><button class="btn btn-primary" id="upGo">Upload</button></div>
        </div>
      </div>`;
    document.body.appendChild(overlay);
    const bs = new bootstrap.Modal(overlay); bs.show();

    const selWrap = overlay.querySelector('#selWrap');
    const vis = overlay.querySelector('#upVis');
    const selList = overlay.querySelector('#selList');
    const selCount = overlay.querySelector('#selCount');
    const ackReq = overlay.querySelector('#upAckReq');
    const ackDueWrap = overlay.querySelector('#ackDueWrap');
    const ackDue = overlay.querySelector('#upAckDue');
    let selected = [];

    vis.addEventListener('change', ()=>{ selWrap.style.display = vis.value==='selected' ? '' : 'none'; });
    ackReq.addEventListener('change', ()=>{ ackDueWrap.style.display = ackReq.checked ? '' : 'none'; });
    overlay.querySelector('#empAdd').addEventListener('click', ()=> searchEmp(overlay, selList, selected, selCount));

    overlay.querySelector('#upGo').addEventListener('click', async ()=>{
      const title = overlay.querySelector('#upTitle').value.trim(); if (!title) { note('Title required','warning'); return; }
      const file = overlay.querySelector('#upPick').files[0]; if (!file) { note('Pick a file','warning'); return; }
      const fd = new FormData();
      fd.append('title', title);
      fd.append('description', overlay.querySelector('#upDesc').value.trim());
      fd.append('category', overlay.querySelector('#upCat').value.trim());
      fd.append('visibility', vis.value);
      fd.append('selected_employees', JSON.stringify(selected.map(x=>x.id)));
      fd.append('ack_required', ackReq.checked ? '1' : '0');
      if (ackReq.checked && ackDue.value) fd.append('ack_due_at', ackDue.value.replace('T',' '));
      fd.append('file', file);
      try{
        const res = await fetch('api/documents.php?action=upload', { method:'POST', credentials:'same-origin', body: fd });
        const js = await res.json();
        if (js?.success) { note('Uploaded','success'); bs.hide(); setTimeout(()=>overlay.remove(),300); loadList(); }
        else note(js?.message||'Upload failed','error');
      }catch(_){ note('Upload failed','error'); }
    });

    overlay.querySelector('[data-bs-dismiss="modal"]').addEventListener('click', ()=>{ bs.hide(); setTimeout(()=>overlay.remove(),300); });
  }

  async function ackDoc(id){
    if (!confirm('I have read and understood this document. Proceed to acknowledge?')) return;
    const comment = '';
    try{
      const res = await fetch('api/documents.php?action=ack', { method:'POST', headers:{'Content-Type':'application/json'}, credentials:'same-origin', body: JSON.stringify({ id, comment }) });
      const js = await res.json();
      if (js?.success){ note('Acknowledged','success'); loadList(); }
      else note(js?.message||'Failed to acknowledge','error');
    }catch(_){ note('Failed to acknowledge','error'); }
  }

  async function viewAckStatus(id){
    try{
      const res = await fetch('api/documents.php?action=acks&id='+id, { credentials:'same-origin' });
      const js = await res.json(); if (!js?.success){ note(js?.message||'Failed to load acknowledgment status','error'); return; }
      const d = js.data||{}; const acked = d.acked||[]; const pending = d.pending||[];
      const overlay = document.createElement('div');
      overlay.className = 'modal fade show'; overlay.style.display='block';
      overlay.innerHTML = `
        <div class="modal-dialog modal-lg">
          <div class="modal-content">
            <div class="modal-header"><h5 class="modal-title">Acknowledgments: ${esc(d.document?.title||'')}</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
            <div class="modal-body">
              <div class="row g-3">
                <div class="col-md-6">
                  <h6 class="mb-2">Acknowledged (${acked.length})</h6>
                  <div class="list-group" style="max-height:260px; overflow:auto;">
                    ${acked.map(a=> `<div class="list-group-item d-flex justify-content-between align-items-center">
                        <span>${esc((a.first_name||'')+' '+(a.last_name||''))}</span>
                        <span class="badge bg-success">${esc(a.acknowledged_at || '')}</span>
                      </div>`).join('') || '<div class="text-muted">None</div>'}
                  </div>
                </div>
                <div class="col-md-6">
                  <h6 class="mb-2">Pending (${pending.length})</h6>
                  <div class="list-group" style="max-height:260px; overflow:auto;">
                    ${pending.map(p=> `<div class="list-group-item">${esc((p.first_name||'')+' '+(p.last_name||''))}</div>`).join('') || '<div class="text-muted">None</div>'}
                  </div>
                </div>
              </div>
            </div>
            <div class="modal-footer"><button class="btn btn-light" data-bs-dismiss="modal">Close</button></div>
          </div>
        </div>`;
      document.body.appendChild(overlay);
      const bs = new bootstrap.Modal(overlay); bs.show();
      overlay.querySelector('[data-bs-dismiss="modal"]').addEventListener('click', ()=>{ bs.hide(); setTimeout(()=>overlay.remove(),300); });
    }catch(_){ note('Failed to load acknowledgment status','error'); }
  }

  async function searchEmp(overlay, selList, selected, selCount){
    const q = overlay.querySelector('#empSearch').value.trim(); if (q.length<2){ note('Type at least 2 characters','warning'); return; }
    try{
      const res = await fetch('api/documents.php?action=employees&q='+encodeURIComponent(q), { credentials:'same-origin' });
      const js = await res.json();
      const rows = js?.success ? (js.data||[]) : [];
      selList.innerHTML = rows.map(r=> `<button class="btn btn-sm btn-outline-primary me-2 mb-2" data-add="${r.id}" data-name="${esc((r.first_name||'')+' '+(r.last_name||''))}"><i class="fas fa-user-plus"></i> ${esc((r.first_name||'')+' '+(r.last_name||''))} ${r.department_name? '<span class="small text-muted">('+esc(r.department_name)+')</span>':''}</button>`).join('') || '<div class="text-muted">No matches</div>';
      selList.querySelectorAll('[data-add]')?.forEach(btn=>{
        btn.addEventListener('click', ()=>{
          const id = Number(btn.getAttribute('data-add'));
          const name = btn.getAttribute('data-name');
          if (!selected.some(x=>x.id===id)){ selected.push({ id, name }); selCount.textContent = String(selected.length); }
        });
      });
    }catch(_){ selList.innerHTML = '<div class="text-danger">Search failed</div>'; }
  }

  function isHr(){ return ['super_admin','admin','hr_head','hr_officer'].includes((window.auth?.currentUser?.role_slug)||window.auth?.currentUser?.role); }
  function formatSize(n){ const x=Number(n||0); if (x>=1024*1024) return (x/1048576).toFixed(1)+' MB'; if (x>=1024) return (x/1024).toFixed(1)+' KB'; return x? (x+' B'):'-'; }
  function formatWhen(ts){ if (!ts) return '-'; try{ const d=new Date(ts.replace(' ','T')); return d.toLocaleString(); }catch(_){ return ts; } }

  window.pages.documents = { render };
})();
