// Product Demo (Slides) for SmartQuantumHR
(function(){
  window.pages = window.pages || {};
  const esc = (s)=>String(s??'').replace(/[&<>"']/g,c=>({"&":"&amp;","<":"&lt;",">":"&gt;","\"":"&quot;","'":"&#39;"}[c]));

  function feature(title, bullets){
    return `<div class="col-lg-4"><div class="p-3 h-100 border rounded-3 bg-white">
      <h6 class="fw-bold mb-2"><i class="fas fa-check-circle text-success me-1"></i>${esc(title)}</h6>
      <ul class="small mb-0 ps-3">${bullets.map(b=>`<li>${esc(b)}</li>`).join('')}</ul>
    </div></div>`;
  }

  function benefitsBySize(){
    return `
    <div class="card mt-4">
      <div class="card-header"><h5 class="mb-0">Why SmartQuantumHR</h5></div>
      <div class="card-body">
        <div class="row g-3">
          ${feature('For Small Businesses',[
            'Start fast with out‑of‑the‑box workflows',
            'Affordable pricing; scale as you grow',
            'Self‑service leave, payslips, and documents'
          ])}
          ${feature('For Medium Enterprises',[
            'Role‑based dashboards for HR/Managers/Employees',
            'Recruitment, Appraisals, Training & Attendance',
            'Configurable approvals and notifications'
          ])}
          ${feature('For Large Organizations',[
            'Grade‑based policies, payroll components & analytics',
            'Advanced reporting & scheduling',
            'Security, audit logs, and fine‑grained roles'
          ])}
        </div>
      </div>
    </div>`;
  }
  window.pages.demo = { render: async function(container){
    container.innerHTML = `
      <div class="card">
        <div class="card-body p-0">
          <div id="demoCarousel" class="carousel slide" data-bs-ride="carousel">
            <div class="carousel-indicators">
              <button type="button" data-bs-target="#demoCarousel" data-bs-slide-to="0" class="active" aria-current="true" aria-label="Slide 1"></button>
              ${Array.from({length:9}).map((_,i)=>`<button type="button" data-bs-target="#demoCarousel" data-bs-slide-to="${i+1}" aria-label="Slide ${i+2}"></button>`).join('')}
            </div>
            <div class="carousel-inner">
              <!-- Slide 1: Hero -->
              <div class="carousel-item active">
                <div class="d-flex align-items-center justify-content-center text-center" style="height:320px; background:linear-gradient(135deg, #1A3E73 0%, #3b82f6 100%); color:white;">
                  <div>
                    <img src="assets/img/smartquantumhr-logo.svg" alt="SmartQuantumHR" style="height:64px; filter: drop-shadow(0 2px 2px rgba(0,0,0,.15));" />
                    <h2 class="mt-3 mb-1 fw-bold">SmartQuantumHR</h2>
                    <div class="lead">Empowering Teams with Intelligent HR</div>
                    <div class="mt-3">
                      <a href="#/dashboard_hr" class="btn btn-light btn-sm me-2" onclick="app.showPage('dashboard_hr'); return false;">HR Dashboard</a>
                      <a href="#/dashboard_staff" class="btn btn-outline-light btn-sm" onclick="app.showPage('dashboard_staff'); return false;">Staff Dashboard</a>
                    </div>
                  </div>
                </div>
              </div>
              <!-- Slide 2: Role-based Dashboards -->
              <div class="carousel-item">
                <div class="p-4">
                  <h4 class="fw-bold">Role-based Dashboards</h4>
                  <p class="text-muted">Personalized insights for HR, Managers, and Employees.</p>
                  <div class="row g-3">
                    ${feature('HR Analytics', ['Headcount, gender & departments','Vacancies & hiring trend','Leave utilization'])}
                    ${feature('Manager View', ['Team attendance & approvals','Announcements & tasks','Messages & calendar'])}
                    ${feature('Employee Self‑Service', ['Leave requests & payslips','Documents & certificates','Training enrollments'])}
                  </div>
                </div>
              </div>
              <!-- Slide 3: People & Organization -->
              <div class="carousel-item"><div class="p-4">
                <h4 class="fw-bold">People & Organization</h4>
                <p class="text-muted">Employees, Departments, Positions, Grades.</p>
                <div class="row g-3">
                  ${feature('Employee 360°', ['Profile, contracts, salary history','Skills, certificates, benefits','Employment history'])}
                  ${feature('Organization', ['Departments & branches','Positions & grades','Org structure & heads'])}
                  ${feature('Compliance', ['Document management','Audit trails','Configurable access'])}
                </div>
              </div></div>
              <!-- Slide 4: Recruitment -->
              <div class="carousel-item"><div class="p-4">
                <h4 class="fw-bold">Recruitment</h4>
                <p class="text-muted">Jobs, Candidates, Applications, Pipeline.</p>
                <div class="row g-3">
                  ${feature('Job Postings', ['Multiple departments/positions','Status: draft/open/closed','Salary range & remote'])}
                  ${feature('Candidates', ['Profiles & documents','Status tracking','Notes & communications'])}
                  ${feature('Selections', ['Shortlisting & interviews','Offers & onboarding','Hiring analytics'])}
                </div>
              </div></div>
              <!-- Slide 5: Leave Management -->
              <div class="carousel-item"><div class="p-4">
                <h4 class="fw-bold">Leave Management</h4>
                <p class="text-muted">Types, allocations, balances, workflows.</p>
                <div class="row g-3">
                  ${feature('Types & Policies', ['Annual, Sick, Maternity, etc.','Grade‑based allocations','Carry‑forward options'])}
                  ${feature('Workflows', ['Multi‑level approvals','Delegations & comments','Notifications'])}
                  ${feature('Insights', ['Utilization by type','Pending vs approved','Team calendar'])}
                </div>
              </div></div>
              <!-- Slide 6: Attendance & Planner -->
              <div class="carousel-item"><div class="p-4">
                <h4 class="fw-bold">Attendance & Planner</h4>
                <p class="text-muted">Clock‑ins, breaks, overtime, company calendar.</p>
                <div class="row g-3">
                  ${feature('Attendance', ['Daily status & notes','Overtime & exceptions','Exports'])}
                  ${feature('Company Calendar', ['Events & reminders','Holidays','Birthdays & anniversaries'])}
                  ${feature('Notifications', ['Due reminders','Email & in‑app','Mark as read'])}
                </div>
              </div></div>
              <!-- Slide 7: Payroll & Payslips -->
              <div class="carousel-item"><div class="p-4">
                <h4 class="fw-bold">Payroll & Payslips</h4>
                <p class="text-muted">Components, taxes, benefits, and secure payslips.</p>
                <div class="row g-3">
                  ${feature('Components', ['Allowances & deductions','Grade defaults & overrides','Multi‑currency'])}
                  ${feature('Processing', ['Status control & approvals','Audit logs','Email payslips'])}
                  ${feature('Employee Access', ['My Payslips portal','Download & print','Company branding'])}
                </div>
              </div></div>
              <!-- Slide 8: Performance & Training -->
              <div class="carousel-item"><div class="p-4">
                <h4 class="fw-bold">Performance & Training</h4>
                <p class="text-muted">Appraisals, templates, and development plans.</p>
                <div class="row g-3">
                  ${feature('Appraisals', ['Templates & competencies','Workflows & scoring','Reviewer assignments'])}
                  ${feature('Training', ['Sessions & participants','Completion tracking','Certificates'])}
                  ${feature('Talent Growth', ['Skills & interests','Learning history','Career pathways'])}
                </div>
              </div></div>
              <!-- Slide 9: Documents & Messaging -->
              <div class="carousel-item"><div class="p-4">
                <h4 class="fw-bold">Documents & Messaging</h4>
                <p class="text-muted">Secure storage, acknowledgments, and in‑app messaging.</p>
                <div class="row g-3">
                  ${feature('Documents', ['Visibility controls','Acknowledgments','Versioning'])}
                  ${feature('Messaging', ['Inbox & Sent','Compose with employee search','Read receipts'])}
                  ${feature('Announcements', ['Company‑wide updates','Priority flags','Expiry controls'])}
                </div>
              </div></div>
              <!-- Slide 10: Analytics & Reports -->
              <div class="carousel-item"><div class="p-4">
                <h4 class="fw-bold">Analytics & Reports</h4>
                <p class="text-muted">Interactive charts and scheduled reports.</p>
                <div class="row g-3">
                  ${feature('Dashboards', ['HR KPIs & charts','Trends & distributions','Leaves & vacancies'])}
                  ${feature('Reports', ['Configurable columns & filters','CSV/Excel export','Scheduling & email'])}
                  ${feature('Auditability', ['Activity logs','System logs','Compliance support'])}
                </div>
              </div></div>
            </div>
            <button class="carousel-control-prev" type="button" data-bs-target="#demoCarousel" data-bs-slide="prev">
              <span class="carousel-control-prev-icon" aria-hidden="true"></span>
              <span class="visually-hidden">Previous</span>
            </button>
            <button class="carousel-control-next" type="button" data-bs-target="#demoCarousel" data-bs-slide="next">
              <span class="carousel-control-next-icon" aria-hidden="true"></span>
              <span class="visually-hidden">Next</span>
            </button>
          </div>
        </div>
      </div>
      ${benefitsBySize()}
      <div class="text-center mt-3">
        <a href="#/recruitment" class="btn btn-primary btn-sm me-2" onclick="app.showPage('recruitment'); return false;">Explore Recruitment</a>
        <a href="#/leave" class="btn btn-outline-primary btn-sm me-2" onclick="app.showPage('leave'); return false;">Explore Leave</a>
        <a href="#/payroll" class="btn btn-outline-primary btn-sm" onclick="app.showPage('payroll'); return false;">Explore Payroll</a>
      </div>
    `;
  }};
})();
