<?php
/**
 * Authentication API Endpoints
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');

require_once '../config/database.php';

$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';

switch ($method) {
    case 'POST':
        if ($action === 'login') {
            handleLogin();
        } elseif ($action === 'logout') {
            handleLogout();
        } elseif ($action === 'touch') {
            handleTouch();
        } else {
            ApiResponse::error('Invalid action');
        }
        break;
    
    case 'GET':
        if ($action === 'check') {
            checkAuth();
        } else {
            ApiResponse::error('Invalid action');
        }
        break;
    
    default:
        ApiResponse::error('Method not allowed', 405);
}

function handleLogin() {
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['username']) || !isset($input['password'])) {
        ApiResponse::error('Username and password required');
    }
    
    $auth = new Auth();
    $user = $auth->authenticate($input['username'], $input['password']);
    
    if ($user) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['user'] = $user;
        $_SESSION['last_activity'] = time();
        
        ApiResponse::success([
            'user' => $user,
            'token' => session_id()
        ], 'Login successful');
    } else {
        ApiResponse::error('Invalid credentials', 401);
    }
}

function handleLogout() {
    if (isset($_SESSION['user_id'])) {
        $auth = new Auth();
        $auth->logActivity($_SESSION['user_id'], 'user_logout');
    }
    
    session_destroy();
    ApiResponse::success(null, 'Logged out successfully');
}

function checkAuth() {
    if (isset($_SESSION['user_id'])) {
        ApiResponse::success([
            'authenticated' => true,
            'user' => $_SESSION['user']
        ]);
    } else {
        ApiResponse::success([
            'authenticated' => false
        ]);
    }
}

function handleTouch() {
    $now = time();
    if (!isset($_SESSION['user_id'])) {
        ApiResponse::success(['authenticated' => false]);
    }
    $last = isset($_SESSION['last_activity']) ? (int)$_SESSION['last_activity'] : $now;
    if (defined('IDLE_TIMEOUT_SECONDS') && ($now - $last) > IDLE_TIMEOUT_SECONDS) {
        @session_unset();
        @session_destroy();
        ApiResponse::unauthorized('Session expired due to inactivity');
    }
    $_SESSION['last_activity'] = $now;
    ApiResponse::success(['authenticated' => true, 'last_activity' => $now]);
}
?>
